# -*- coding: cp1252 -*-
overrideIcon= "o_nvidia"

######################################################################
#
# Name:  Collect NVidia driver version
# Author:  Royal Render, Holger Schoenberger, Binary Alchemy
# Version: 
# Description: 
#   This tool creates a batch file that executes a Nvidia tool that displays information like  
#   the installed graphic card and the driver versions. Newer graphic cards with a driver version later
#   than 361 can execute CUDA renderer even if the client is running as background service.
#   The output is parsed by rrParseOutput which creates a .csv table (open in e.g. Excel)
#   And it adds/removes the client to/from a client group "ServiceGPU" IF ENABLED
#
# Copyright (c) Holger Schoenberger - Binary Alchemy
######################################################################
import os

addToGroup= False 

messageStr="Information: \n"
messageStr=messageStr+"This scripted job example collects information about all Nvidia GPUs on clients\n"
messageStr=messageStr+"and saves them into an .csv (excel) table.\n"
if addToGroup:
    messageStr=messageStr+"And it adds clients that have TCC mode enabled\n"
    messageStr=messageStr+"within a service to the client group 'ServiceGPU' \n"
messageStr=messageStr+"\n"
messageStr=messageStr+"How it works: \n"
messageStr=messageStr+"It first creates a batch file in the folder RR/inhouse/ \n"
messageStr=messageStr+"and then a job that executes this batch file\n"
rrGlobal.messageBox(rrGlobal.logLvL.info, messageStr)



fileBaseName=rrGlobal.rrRootPath()+"inhouse\\rrCollectNvidia"
if (not os.path.isdir(rrGlobal.rrRootPath()+"inhouse")):
    os.mkdir(rrGlobal.rrRootPath()+"inhouse")




#The commandline will be written as universal OS code and then written per OS
batchF = rrGlobal.getCrossBatch()
batchF.osVarAdd("ErrorLevel","%ERRORLEVEL%","$?","$?")  #Note: debian uses $status and not $?
batchF.osVarAdd("rrParseOutput_Exe","rrParseOutput","rrParseOutput","rrParseOutput.app\Contents\MacOS\rrParseOutput")
batchF.osVarAdd("NVSMI", "%ProgramFiles%\\NVIDIA Corporation\\NVSMI\\nvidia-smi.exe","/usr/bin/nvidia-smi", "/usr/bin/nvidia-smi" )
batchF.setBaseFileName(fileBaseName)

#first part adds clients to the group
batchF.addLine("<comment> This file was automatically created by a rrSubmitter Scripted Job Plugin ")
batchF.addFlag("<rrBin><rrParseOutput_Exe>")
batchF.addFlag("'<NVSMI>'")
batchF.addFlag("compare")
batchF.addFlag("Driver Version:;;|")
batchF.addFlag("Q-largerNumberP")
batchF.addFlag("361")
batchF.addEnd()
if addToGroup:
    batchF.addFlag("<rrBin>rrPythonconsole")
    batchF.addFlag("<RR_ROOT>/render_apps/scripts/pyRR_addClientToGroup.py")
    batchF.add("-group ServiceGPU -addClient <ErrorLevel>")
    batchF.addEnd()


batchF.addEnd()


#Now we create a table with the information 
batchF.addFlag("<rrBin><rrParseOutput_Exe>")
batchF.addFlag("'<NVSMI>'")
batchF.addFlag("table")
batchF.addFlag(fileBaseName+"_result.csv")
batchF.addFlag("-showCmdOutput")
batchF.addFlag("-addAllClients")

batchF.addFlag("Workstation,Unique=[host]")
batchF.addFlag("Updated=[dateMonth]")
batchF.addFlag("Executed=[success]")
batchF.addFlag("Error=[error]")
batchF.addFlag("Driver Version,NumberP=Driver Version:;;|")
batchF.addFlag("GPU 0=|   0;;|")
batchF.addFlag("GPU 1=|   1;;|")
batchF.addFlag("GPU 2=|   2;;|")


batchF.addEnd()

batchF.addEnd()



if not batchF.saveWin():
    raise Exception(batchF.fileErrorMessage())

if not batchF.saveLx():
    raise Exception(batchF.fileErrorMessage())

if not batchF.saveOsx():
    raise Exception(batchF.fileErrorMessage())






#Create a job
renderApp= rrJob._RenderAppBasic()
renderApp.clear()
renderApp.name="Execute"
renderApp.type="Execute"
renderApp.executeType=rrGlobal.executeJobType.onceEachClient
renderApp.rendererName="Nvidia check"



newJob=  rr.getNewJob()
newJob.overrideIcon=overrideIcon;
newJob.sceneName=batchF.getOSFileName(0);
newJob.renderApp=renderApp
newJob.companyProjectName="rrCommand"
newJob.imageFileName=fileBaseName+"_result.csv"
newJob.imageSingleOutputFile=True
newJob.splitImageFileInto_DirFileExt(False)
newJob.uiIsChecked= True
newJob.layer="NvidiaVersionCheck"

rr.setSubmitterParameter("MaxClientsAtATime=0~5")




rr.jobAll_set(999,newJob);  # If the index of the job is higher than the number of jobs,
                            # then a new job is added to the end of the job list. So I use 999.
